/*
 * QrfeMessageQueue.h
 *
 *  Created on: 22.06.2010
 *      Author: stefan.detter
 */

#ifndef QRFEMESSAGEQUEUE_H_
#define QRFEMESSAGEQUEUE_H_

#include <QObject>
#include <QMap>
#include <QMutex>
#include <QWaitCondition>

#include <QrfeTraceModule>

class QrfeMessageQueue : public QObject , QrfeTraceModule
{
	Q_OBJECT

public:
	QrfeMessageQueue(QObject* parent = 0);
	virtual ~QrfeMessageQueue();

	void		setSingleThread(bool alive);
	bool		currentlyWaiting();

	void 		clearMessage (int id);
	QByteArray 	waitForMessage (int id, uint msecs, bool *ok);
	void 		enqueMessage (int id, const QByteArray& message);

private:
	QMap<int, QList<QByteArray> >	m_messages;
	QMutex*							m_messageMutex;

	QMutex 					m_waitMutex;
	QWaitCondition			m_messageAvailable;

	bool					m_singleThread;
};

#endif /* QRFEMESSAGEQUEUE_H_ */
